N (*****************************************************************************N  *                               Q L O G I N                                 *N  *                              -------------                                *N  *                                                                           *N  *  This module is part of the QLogin package developed by Marc A. Shannon   *N  *  of the Computer Club at Carnegie-Mellon University.                      *N  *                                                                           *N  *  This program, either complete or in part, may not be redistributed for   *N  *  profit.  This program, and all modules, are:                             *N  *      Copyright (C) 1991 by Marc A. Shannon and the CMU Computer Club      *N  *                                                                           *N  *  Redistribution of this package is not otherwise restricted.              *N  *                                                                           *O  *****************************************************************************)  [Ident('V1.0'),   Environment('Housekeeping'),   Inherit('Common',          'QueueDef',          'Queue',           'Interact',          'Priv_Bypass',            'Sys$Library:Starlet')]' Module Housekeeping(LoadAverageDevice);   I { Housekeeping is responsible for updating the system information (number H   of users and current loads) as well as checking on people currently in   the queue. }   Const TimerID = %X12344321;   ( Var LoadAverageDevice : [Volatile] Text;(     HouseKeepingTimer : [Volatile] Quad;   [Initialize, Hidden] Procedure OpenLAVdevice;   Begin C    Open(LoadAverageDevice, 'LAV:', ReadOnly, Sharing := ReadWrite);     Reset(LoadAverageDevice)  End;   Procedure Housekeeping;    Var Loop, Next : QueueEntryPtr; !     DeviceItemList : ItemList(1);      DeviceStatus : DEV$TYPE;   Begin 	    Repeat K       { Load in the current average.  We don't want the one-minute average, N         so we read in the five-minute average on top of the one-minute read. }7       Readln(LoadAverageDevice, CurrentLoad::RealChars, %              CurrentLoad::RealChars);          If NumInQueue > 0 Then          Begin+             Set_ItemList(DeviceItemList, 1, 1                          ItmCod := DVI$_DEVCHAR2, 6                          BufLen := Size(DeviceStatus),;                          BufAdr := IAddress(DeviceStatus));                Loop := Queue.Head;               While Loop <> Nil Do                Begin%                   Next := Loop^.Next; %                   Case Loop^.State Of .                      Unused : KillEntry(Loop);9                      Start_IO : Start_Interaction(Loop^); P                      Waiting : If (Not Odd($GETDVIW(Chan := Loop^.Terminal_Chan,O                                                     ItmLst := DeviceItemList))) G                                   Or_Else (DeviceStatus.DEV$V_DET) Then '                                   Begin B                                      $DELPRC(PidAdr := Loop^.PID);J                                      $CANCEL(Chan := Loop^.Terminal_Chan);A                                      Loop^.State := ToBeReleased; O                                      WakeUp     { Will prevent sleeping below } &                                   End;7                      Notify : Send_Queue_Status(Loop^); =                      ToBeReleased : Delete_From_Queue(Loop^); 5                      SpyForPriv : Start_Spying(Loop^)                    End;                   Loop := Next                End;   G             { Is the load low enough to permit the first person on yet? ;               Only check if we are on a Housekeeping run. } =             If ($CLREF(Efn := ClockEF) = SS$_WASSET) And_Then A                (((CurrentLoad <= MaxLoad) Or (MaxLoad = 0.0)) And >                 ((SYS$GW_IJOBCNT - NumInQueue) < MaxUsers) And9                 (Not Debug) And (Queue.Head <> Nil)) Then                 Begin6                   Write_Out(Queue.Head^.Terminal_Chan,.                             ''(7,10)'GO'(10));0                   Delete_From_Queue(Queue.Head^)                End
          End;   N       Debug := Odd($TRNLNM(TabNam := 'LNM$SYSTEM', LogNam := 'QLOGIN_DEBUG'));  (       { Sleep until we are awakened... }0       If $CLREF(Efn := WakeEF) = SS$_WASCLR Then          Begin#             $CLREF(Efn := ClockEF); "             If NumInQueue > 0 Then,                Check($SETIMR(Efn := ClockEF,9                              DayTim := HousekeepingTimer, 1                              ReqIdt := TimerID)); "             $WFLOR(Efn := ClockEF,"                    Mask := EFMask)          End  L    { This procedure never terminates -- it's the "heart" of the scheduling }    Until False End;   End.