N (*****************************************************************************N  *                               Q L O G I N                                 *N  *                              -------------                                *N  *                                                                           *N  *  This module is part of the QLogin package developed by Marc A. Shannon   *N  *  of the Computer Club at Carnegie-Mellon University.                      *N  *                                                                           *N  *  This program, either complete or in part, may not be redistributed for   *N  *  profit.  This program, and all modules, are:                             *N  *      Copyright (C) 1991 by Marc A. Shannon and the CMU Computer Club      *N  *                                                                           *N  *  Redistribution of this package is not otherwise restricted.              *N  *                                                                           *O  *****************************************************************************)  [Ident('V1.0'),   Environment('Attach'),   Inherit('Common',          'QueueDef',           'Sys$Library:Starlet')] Module Attach;  M { Gives the user a chance to attach to a disconnected job should one exist. }    [Asynchronous]4 Procedure Attach_To_Term(Var CurEntry : QueueEntry);   Var ErrorMsg : LongString;     CurUIC : Unsigned;     Ret_Stat : Integer;      Terminal_Descr : Quad;     DVI_ItemList : ItemList(1);    Begin /    If Not Odd(CurEntry.Read_Stat.Ret_Stat) Then        Begin "          CurEntry.State := Notify;          WakeUp 	       End     Else        Begin I          CurEntry.Req_Attach_Terminal.Length := CurEntry.Read_Stat.Bytes; 2          If (CurEntry.Req_Attach_Terminal = '') OrA             ((Length(CurEntry.Req_Attach_Terminal) <= 3) And_Then ,              (CurEntry.Req_Attach_Terminal =M                 Substr('YES', 1, Length(CurEntry.Req_Attach_Terminal)))) Then M             CurEntry.Req_Attach_Terminal := CurEntry.Default_Attach_Terminal;   &          Set_ItemList(DVI_ItemList, 1,H                       BufLen := Size(CurEntry.Req_Attach_Terminal.Body),,                       ItmCod := DVI$_DEVNAM,L                       BufAdr := IAddress(CurEntry.Req_Attach_Terminal.Body),R                       RetLenAdr := IAddress(CurEntry.Req_Attach_Terminal.Length));9          $GETDVIW(DevNam := CurEntry.Req_Attach_Terminal, *                   ItmLst := DVI_ItemList);  5          Write_Out(DevChan := CurEntry.Terminal_Chan, 6                    Data := 'Connecting to terminal ' +9                            CurEntry.Req_Attach_Terminal);   ,          CurUIC := Change_UIC(CurEntry.UIC);C          Terminal_Descr.L0 := Length(CurEntry.Req_Attach_Terminal); J          Terminal_Descr.L1 := IAddress(CurEntry.Req_Attach_Terminal.Body);  :          Ret_Stat := $QIOW(Chan := CurEntry.Terminal_Chan,A                            Func := IO$_SETMODE + IO$M_TT_CONNECT, 6                            IOSB := CurEntry.Read_Stat,1                            P1 := Terminal_Descr); G          If Odd(Ret_Stat) Then Ret_Stat := CurEntry.Read_Stat.Ret_Stat;           Change_UIC(CurUIC);            If Odd(Ret_Stat) Then             Begin /                $DELPRC(PidAdr := CurEntry.PID); .                CurEntry.State := ToBeReleased;                WakeUp              End 
          Else              Begin )                $GETMSG(MsgId := Ret_Stat, 1                        MsgLen := ErrorMsg.Length, /                        BufAdr := ErrorMsg.Body, G                        Flags := 2#0001);  { Include message text only } 2                If (Length(ErrorMsg) >= 1) And_Then2                   (ErrorMsg[1] In ['a'..'z']) Then<                   ErrorMsg[1] := Chr(Ord(ErrorMsg[1]) - 32);  ;                Write_Out(DevChan := CurEntry.Terminal_Chan, +                          Data := ErrorMsg); (                CurEntry.State := Notify;                WakeUp              End 	       End  End;   [Asynchronous]6 Procedure Verify_Passwords(Var CurEntry : QueueEntry);   Var JPI_Context : Unsigned; !     PSCAN_ItemList : ItemList(4);      JPI_ItemList : ItemList(4); 4     Proc_List : Array [1..Max_Attach_PIDs] of Record>                                                  TerminalName,=                                                  ProcessName, G                                                  ImageName : LongString 2                                               End;$     Num_Procs, Loop_Procs : Integer;     JPI_Stat : Integer; !     PhyTerminalName : LongString;      TmpOut : LongString;   Begin ;    If (CurEntry.Password.L0 <> CurEntry.UAI_Password.L0) Or ;       (CurEntry.Password.L1 <> CurEntry.UAI_Password.L1) Or C       (CurEntry.Password_2nd.L0 <> CurEntry.UAI_Password_2nd.L0) Or E       (CurEntry.Password_2nd.L1 <> CurEntry.UAI_Password_2nd.L1) Then        Begin 5          Write_Out(DevChan := CurEntry.Terminal_Chan, 9                    Data := 'User authorization failure'); "          CurEntry.State := Notify;          WakeUp 	       End E    Else If UAnd(CurEntry.UAI_Flags, UAI$M_AUTOLOGIN + UAI$M_DISACNT + ,                 UAI$M_DISRECONNECT) > 0 Then       Begin 5          Write_Out(DevChan := CurEntry.Terminal_Chan, O                    Data := 'You are not permitted to attach to existing jobs'); "          CurEntry.State := Notify;          WakeUp 	       End     Else        Begin K          { Now we need to find the user's disconnected processes (if any) } (          Set_ItemList(PSCAN_ItemList, 1,"                       BufLen := 0,,                       ItmCod := PSCAN$_MODE,2                       BufAdr := JPI$K_INTERACTIVE,0                       RetLenAdr := PSCAN$M_EQL);(          Set_ItemList(PSCAN_ItemList, 2,9                       BufLen := CurEntry.Username.Length, 0                       ItmCod := PSCAN$_USERNAME,A                       BufAdr := IAddress(CurEntry.Username.Body), 0                       RetLenAdr := PSCAN$M_EQL);(          Set_ItemList(PSCAN_ItemList, 3,"                       BufLen := 0,-                       ItmCod := PSCAN$_OWNER, "                       BufAdr := 0,0                       RetLenAdr := PSCAN$M_EQL);(          Set_ItemList(PSCAN_ItemList, 4,"                       BufLen := 0,+                       ItmCod := PSCAN$_UIC, -                       BufAdr := CurEntry.UIC, 0                       RetLenAdr := PSCAN$M_EQL);          JPI_Context := 0;-          $PROCESS_SCAN(PidCtx := JPI_Context, 1                        ItmLst := PSCAN_ItemList);             Num_Procs := 0;          Repeat ,             With Proc_List[Num_Procs + 1] Do                Begin/                   Set_ItemList(JPI_ItemList, 1, A                                BufLen := Size(TerminalName.Body), 7                                ItmCod := JPI$_TERMINAL, E                                BufAdr := IAddress(TerminalName.Body), K                                RetLenAdr := IAddress(TerminalName.Length)); /                   Set_ItemList(JPI_ItemList, 2, @                                BufLen := Size(ProcessName.Body),5                                ItmCod := JPI$_PRCNAM, D                                BufAdr := IAddress(ProcessName.Body),J                                RetLenAdr := IAddress(ProcessName.Length));/                   Set_ItemList(JPI_ItemList, 3, >                                BufLen := Size(ImageName.Body),7                                ItmCod := JPI$_IMAGNAME, B                                BufAdr := IAddress(ImageName.Body),H                                RetLenAdr := IAddress(ImageName.Length));/                   Set_ItemList(JPI_ItemList, 4, D                                BufLen := Size(PhyTerminalName.Body),;                                ItmCod := JPI$_TT_PHYDEVNAM, H                                BufAdr := IAddress(PhyTerminalName.Body),M                                RetLenAdr := IAddress(PhyTerminalName.Length))                 End;   7             JPI_Stat := $GETJPIW(PidAdr := JPI_Context, 9                                  ItmLst := JPI_ItemList);   A             If Odd(JPI_Stat) And_Then (PhyTerminalName = '') Then )                Num_Procs := Num_Procs + 1   B          Until Not Odd(JPI_Stat) Or (Num_Procs = Max_Attach_PIDs);            If Num_Procs = 0 Then             Begin ;                Write_Out(DevChan := CurEntry.Terminal_Chan, N                          Data := '    [No disconnected processes found for ' +)                                  'you]'); (                CurEntry.State := Notify;                WakeUp              End 
          Else              Begin K                TmpOut := '    You have the following disconnected process'; $                If Num_Procs > 1 Then*                   TmpOut := TmpOut + 'es';&                TmpOut := TmpOut + ':';;                Write_Out(DevChan := CurEntry.Terminal_Chan, )                          Data := TmpOut);   ;                Write_Out(DevChan := CurEntry.Terminal_Chan, J                          Data := 'Terminal   Process name    Image name');  2                For Loop_Procs := 1 To Num_Procs Do                   Begin 2                      With Proc_List[Loop_Procs] Do                         Begin 1                            If ImageName = '' Then 4                               ImageName := '(none)';7                            WriteV(TmpOut, TerminalName, B                                   ' ':(11 - Length(TerminalName)),.                                   ProcessName,A                                   ' ':(16 - Length(ProcessName)), ,                                   ImageName)                         End;  A                      Write_Out(DevChan := CurEntry.Terminal_Chan, .                                Data := TmpOut)                   End;M                CurEntry.Default_Attach_Terminal := Proc_List[1].TerminalName;   $                If Num_Procs > 1 Then>                   TmpOut := 'Enter terminal to connect to [' +=                      CurEntry.Default_Attach_Terminal + ']: '                 Else F                   TmpOut := 'Connect to above listed process [YES]: ';  3                $QIO(Chan := CurEntry.Terminal_Chan, F                     Func := IO$_READPROMPT + IO$M_CVTLOW + IO$M_TIMED,/                     IOSB := CurEntry.Read_Stat, >                     AstAdr := %Immed IAddress(Attach_To_Term),8                     AstPrm := %Immed IAddress(CurEntry),<                     P1 := CurEntry.Req_Attach_Terminal.Body,B                     P2 := Size(CurEntry.Req_Attach_Terminal.Body),6                     P3 := 15, { seconds till timeout }7                     P5 := %Immed IAddress(TmpOut.Body), (                     P6 := TmpOut.Length)             End 	       End  End;   [Asynchronous]3 Procedure Work_Password(Var CurEntry : QueueEntry);    Begin /    If Not Odd(CurEntry.Read_Stat.Ret_Stat) Then        Begin "          CurEntry.State := Notify;          WakeUp 	       End     Else        Begin B          CurEntry.Password_Str.Length := CurEntry.Read_Stat.Bytes;J          If (CurEntry.Password.L0 = 0) And (CurEntry.Password.L1 = 0) Then             Begin ;                $HASH_PASSWORD(Pwd := CurEntry.Password_Str, 6                               Alg := CurEntry.Encrypt,4                               Salt := CurEntry.Salt,:                               UsrNam := CurEntry.Username,9                               Hash := CurEntry.Password);   8                If (CurEntry.UAI_Password_2nd.L0 <> 0) Or:                   (CurEntry.UAI_Password_2nd.L1 <> 0) Then                   Begin A                      Write_Out(DevChan := CurEntry.Terminal_Chan, +                                Data := ''); 9                      $QIO(Chan := CurEntry.Terminal_Chan, M                           Func := IO$_READPROMPT + IO$M_CVTLOW + IO$M_TIMED + .                                   IO$M_NOECHO,5                           IOSB := CurEntry.Read_Stat, F                           AstAdr := %Immed IAddress(Verify_Passwords),>                           AstPrm := %Immed IAddress(CurEntry),L                           P1 := %Immed IAddress(CurEntry.Password_Str.Body),A                           P2 := Size(CurEntry.Password_Str.Body), <                           P3 := 15, { seconds till timeout }2                           P5 := %Ref 'Password: ',;                           P6 := 10) { length of P5 string }                    End                 Else F                   $DCLAST(AstAdr := %Immed IAddress(Verify_Passwords),>                           AstPrm := %Immed IAddress(CurEntry))             End 
          Else              Begin ;                $HASH_PASSWORD(Pwd := CurEntry.Password_Str, :                               Alg := CurEntry.Encrypt_2nd,4                               Salt := CurEntry.Salt,:                               UsrNam := CurEntry.Username,=                               Hash := CurEntry.Password_2nd);   C                $DCLAST(AstAdr := %Immed IAddress(Verify_Passwords), ;                        AstPrm := %Immed IAddress(CurEntry))              End 	       End  End;   [Asynchronous]2 Procedure Get_Password(Var CurEntry : QueueEntry);   Var UAI_ItemList : ItemList(7);    Begin /    If Not Odd(CurEntry.Read_Stat.Ret_Stat) Then        Begin "          CurEntry.State := Notify;          WakeUp 	       End     Else        Begin >          CurEntry.Username.Length := CurEntry.Read_Stat.Bytes;  K          { We need to fetch the UAI information and load it here so we know *            what to do about passwords... }&          Set_ItemList(UAI_ItemList, 1,<                       BufLen := Size(CurEntry.UAI_Password),)                       ItmCod := UAI$_PWD, A                       BufAdr := IAddress(CurEntry.UAI_Password)); &          Set_ItemList(UAI_ItemList, 2,@                       BufLen := Size(CurEntry.UAI_Password_2nd),*                       ItmCod := UAI$_PWD2,E                       BufAdr := IAddress(CurEntry.UAI_Password_2nd)); &          Set_ItemList(UAI_ItemList, 3,7                       BufLen := Size(CurEntry.Encrypt), -                       ItmCod := UAI$_ENCRYPT, <                       BufAdr := IAddress(CurEntry.Encrypt));&          Set_ItemList(UAI_ItemList, 4,;                       BufLen := Size(CurEntry.Encrypt_2nd), -                       ItmCod := UAI$_ENCRYPT, @                       BufAdr := IAddress(CurEntry.Encrypt_2nd));&          Set_ItemList(UAI_ItemList, 5,4                       BufLen := Size(CurEntry.Salt),*                       ItmCod := UAI$_SALT,9                       BufAdr := IAddress(CurEntry.Salt)); &          Set_ItemList(UAI_ItemList, 6,3                       BufLen := Size(CurEntry.UIC), )                       ItmCod := UAI$_UIC, 8                       BufAdr := IAddress(CurEntry.UIC));&          Set_ItemList(UAI_ItemList, 7,9                       BufLen := Size(CurEntry.UAI_Flags), +                       ItmCod := UAI$_FLAGS, >                       BufAdr := IAddress(CurEntry.UAI_Flags));  8          If Not Odd($GetUAI(UsrNam := CurEntry.Username,9                             ItmLst := UAI_ItemList)) Then              Begin B                CurEntry.UAI_Password.L0 := 1;   { ensure failure },                CurEntry.UAI_Password.L1 := 0             End;  .          If (CurEntry.UAI_Password.L0 = 0) And/             (CurEntry.UAI_Password.L1 = 0) Then @             $DCLAST(AstAdr := %Immed IAddress(Verify_Passwords),8                     AstPrm := %Immed IAddress(CurEntry))
          Else              Begin +                CurEntry.Password_Str := ''; )                CurEntry.Password := Zero; -                CurEntry.Password_2nd := Zero;   3                $QIO(Chan := CurEntry.Terminal_Chan, G                     Func := IO$_READPROMPT + IO$M_CVTLOW + IO$M_TIMED + (                             IO$M_NOECHO,/                     IOSB := CurEntry.Read_Stat, =                     AstAdr := %Immed IAddress(Work_Password), 8                     AstPrm := %Immed IAddress(CurEntry),F                     P1 := %Immed IAddress(CurEntry.Password_Str.Body),;                     P2 := Size(CurEntry.Password_Str.Body), 6                     P3 := 15, { seconds till timeout },                     P5 := %Ref 'Password: ',5                     P6 := 10) { length of P5 string }              End 	       End  End;   [Asynchronous]. Procedure ReAttach(Var CurEntry : QueueEntry);   Begin /    Write_Out(DevChan := CurEntry.Terminal_Chan, O              Data := ''(10)'    [Attaching to existing disconnected job]'(10));   '    $QIO(Chan := CurEntry.Terminal_Chan, :         Func := IO$_READPROMPT + IO$M_CVTLOW + IO$M_TIMED,#         IOSB := CurEntry.Read_Stat, 0         AstAdr := %Immed IAddress(Get_Password),,         AstPrm := %Immed IAddress(CurEntry),6         P1 := %Immed IAddress(CurEntry.Username.Body),+         P2 := Size(CurEntry.Username.Body), *         P3 := 15, { seconds till timeout }          P5 := %Ref 'Username: ',)         P6 := 10) { length of P5 string }  End;   End.