/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.awt.GraphicsConfiguration;
import java.awt.image.ColorModel;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.windows.Win32OffScreenSurfaceData;
import sun.java2d.windows.WindowsFlags;

public class WinVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;
    private boolean d3dAccelerationEnabled;

    public WinVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)sunVolatileImage.getGraphicsConfig().getDevice();
        this.d3dAccelerationEnabled = this.accelerationEnabled = WindowsFlags.isDDEnabled() && WindowsFlags.isDDOffscreenEnabled() && sunVolatileImage.getTransparency() == 1;
    }

    protected SurfaceData createAccelSurface() {
        int n = this.vImg.getTransparency();
        GraphicsConfiguration graphicsConfiguration = this.vImg.getGraphicsConfig();
        ColorModel colorModel = n != 3 ? this.getDeviceColorModel() : graphicsConfiguration.getColorModel(3);
        Win32OffScreenSurfaceData win32OffScreenSurfaceData = null;
        if (this.d3dAccelerationEnabled && ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).isD3DEnabledOnDevice()) {
            try {
                win32OffScreenSurfaceData = D3DSurfaceData.createData(this.vImg.getWidth(), this.vImg.getHeight(), 65537, colorModel, graphicsConfiguration, this.vImg);
            }
            catch (InvalidPipeException invalidPipeException) {
                // empty catch block
            }
        }
        if (win32OffScreenSurfaceData == null) {
            win32OffScreenSurfaceData = Win32OffScreenSurfaceData.createData(this.vImg.getWidth(), this.vImg.getHeight(), colorModel, graphicsConfiguration, this.vImg, n);
        }
        return win32OffScreenSurfaceData;
    }

    public boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    public void setAccelerationEnabled(boolean bl) {
        if (bl != this.accelerationEnabled) {
            this.sdCurrent = this.getBackupSurface();
            this.sdAccel = null;
            this.accelerationEnabled = bl;
        }
        this.d3dAccelerationEnabled = bl;
    }

    public void setD3DAccelerationEnabled(boolean bl) {
        if (bl != this.d3dAccelerationEnabled) {
            this.sdCurrent = this.getBackupSurface();
            this.sdAccel = null;
            this.d3dAccelerationEnabled = bl;
        }
    }

    public SurfaceData initAcceleratedSurface() {
        SurfaceData surfaceData;
        try {
            surfaceData = this.createAccelSurface();
        }
        catch (InvalidPipeException invalidPipeException) {
            surfaceData = null;
        }
        return surfaceData;
    }

    public SurfaceData restoreContents() {
        this.acceleratedSurfaceLost();
        return super.restoreContents();
    }

    protected ColorModel getDeviceColorModel() {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.vImg.getGraphicsConfig();
        return win32GraphicsConfig.getDeviceColorModel();
    }

    protected void restoreAcceleratedSurface() {
        ((Win32OffScreenSurfaceData)this.sdAccel).restoreSurface();
    }
}

