/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;

    public DefaultCellEditor(final JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            public void setValue(Object object) {
                jTextField.setText(object != null ? object.toString() : "");
            }

            public Object getCellEditorValue() {
                return jTextField.getText();
            }
        };
        jTextField.addActionListener(this.delegate);
    }

    public DefaultCellEditor(final JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new EditorDelegate(){

            public void setValue(Object object) {
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                } else if (object instanceof String) {
                    bl = object.equals("true");
                }
                jCheckBox.setSelected(bl);
            }

            public Object getCellEditorValue() {
                return jCheckBox.isSelected();
            }
        };
        jCheckBox.addActionListener(this.delegate);
        jCheckBox.setRequestFocusEnabled(false);
    }

    public DefaultCellEditor(final JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new EditorDelegate(){

            public void setValue(Object object) {
                jComboBox.setSelectedItem(object);
            }

            public Object getCellEditorValue() {
                return jComboBox.getSelectedItem();
            }

            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }

            public boolean stopCellEditing() {
                if (jComboBox.isEditable()) {
                    jComboBox.actionPerformed(new ActionEvent(DefaultCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        jComboBox.addActionListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= DefaultCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            DefaultCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            DefaultCellEditor.this.fireEditingCanceled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultCellEditor.this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DefaultCellEditor.this.stopCellEditing();
        }
    }
}

