/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.xml.internal.ws.server.DocInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.wsdl.parser.Service;
import com.sun.xml.internal.ws.wsdl.writer.WSDLOutputResolver;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGenResolver
implements WSDLOutputResolver {
    private Map<String, DocInfo> docs;
    private DocInfo abstractWsdl;
    private DocInfo concreteWsdl;
    private Map<String, List<String>> nsMapping;

    public WSDLGenResolver(Map<String, DocInfo> map) {
        this.docs = map;
        this.nsMapping = new HashMap<String, List<String>>();
        Set<Map.Entry<String, DocInfo>> set = map.entrySet();
        for (Map.Entry<String, DocInfo> entry : set) {
            DocInfo docInfo = entry.getValue();
            if (docInfo.isHavingPortType()) {
                this.abstractWsdl = docInfo;
            }
            if (docInfo.getDocType() != DocInfo.DOC_TYPE.SCHEMA) continue;
            List<String> list = this.nsMapping.get(docInfo.getTargetNamespace());
            if (list == null) {
                list = new ArrayList<String>();
                this.nsMapping.put(docInfo.getTargetNamespace(), list);
            }
            list.add(docInfo.getUrl().toString());
        }
    }

    public String getWSDLFile() {
        return this.concreteWsdl.getUrl().toString();
    }

    public Map<String, DocInfo> getDocs() {
        return this.docs;
    }

    public Result getSchemaOutput(String string, String string2) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        StreamDocInfo streamDocInfo = new StreamDocInfo(string2, byteArrayBuffer);
        streamDocInfo.setQueryString("xsd=" + string2);
        streamDocInfo.setDocType(DocInfo.DOC_TYPE.SCHEMA);
        this.docs.put(streamDocInfo.getUrl().toString(), streamDocInfo);
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(byteArrayBuffer);
        streamResult.setSystemId(streamDocInfo.getUrl().toString());
        return streamResult;
    }

    @Override
    public Result getWSDLOutput(String string) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        StreamDocInfo streamDocInfo = new StreamDocInfo(string, byteArrayBuffer);
        streamDocInfo.setDocType(DocInfo.DOC_TYPE.WSDL);
        streamDocInfo.setQueryString("wsdl");
        this.concreteWsdl = streamDocInfo;
        this.docs.put(streamDocInfo.getUrl().toString(), streamDocInfo);
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(byteArrayBuffer);
        streamResult.setSystemId(streamDocInfo.getUrl().toString());
        return streamResult;
    }

    @Override
    public Result getAbstractWSDLOutput(Holder<String> holder) {
        if (this.abstractWsdl != null) {
            holder.value = this.abstractWsdl.getUrl().toString();
            return null;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        StreamDocInfo streamDocInfo = new StreamDocInfo((String)holder.value, byteArrayBuffer);
        streamDocInfo.setDocType(DocInfo.DOC_TYPE.WSDL);
        this.docs.put(streamDocInfo.getUrl().toString(), streamDocInfo);
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(byteArrayBuffer);
        streamResult.setSystemId(streamDocInfo.getUrl().toString());
        return streamResult;
    }

    @Override
    public Result getSchemaOutput(String string, Holder<String> holder) {
        List<String> list = this.nsMapping.get(string);
        if (list != null) {
            if (list.size() > 1) {
                throw new ServerRtException("server.rt.err", "More than one schema for the target namespace " + string);
            }
            holder.value = list.get(0);
            return null;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        StreamDocInfo streamDocInfo = new StreamDocInfo((String)holder.value, byteArrayBuffer);
        streamDocInfo.setDocType(DocInfo.DOC_TYPE.SCHEMA);
        this.docs.put(streamDocInfo.getUrl().toString(), streamDocInfo);
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(byteArrayBuffer);
        streamResult.setSystemId(streamDocInfo.getUrl().toString());
        return streamResult;
    }

    private static class StreamDocInfo
    implements DocInfo {
        private ByteArrayBuffer bout;
        private String resource;
        private String queryString;
        private DocInfo.DOC_TYPE docType;

        public StreamDocInfo(String string, ByteArrayBuffer byteArrayBuffer) {
            this.resource = string;
            this.bout = byteArrayBuffer;
        }

        public InputStream getDoc() {
            this.bout.close();
            return this.bout.newInputStream();
        }

        public String getPath() {
            return this.resource;
        }

        public URL getUrl() {
            try {
                return new URL("file:///" + this.resource);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getQueryString() {
            return this.queryString;
        }

        public void setQueryString(String string) {
            this.queryString = string;
        }

        public void setDocType(DocInfo.DOC_TYPE dOC_TYPE) {
            this.docType = dOC_TYPE;
        }

        public DocInfo.DOC_TYPE getDocType() {
            return this.docType;
        }

        public void setTargetNamespace(String string) {
        }

        public String getTargetNamespace() {
            return null;
        }

        public void setService(Service service) {
        }

        public Service getService() {
            return null;
        }

        public void setHavingPortType(boolean bl) {
        }

        public boolean isHavingPortType() {
            return false;
        }
    }
}

