N (*****************************************************************************N  *                               Q L O G I N                                 *N  *                              -------------                                *N  *                                                                           *N  *  This module is part of the QLogin package developed by Marc A. Shannon   *N  *  of the Computer Club at Carnegie-Mellon University.                      *N  *                                                                           *N  *  This program, either complete or in part, may not be redistributed for   *N  *  profit.  This program, and all modules, are:                             *N  *      Copyright (C) 1991 by Marc A. Shannon and the CMU Computer Club      *N  *                                                                           *N  *  Redistribution of this package is not otherwise restricted.              *N  *                                                                           *O  *****************************************************************************)  [Ident('V1.0'),   Environment('Mailbox'),  Inherit('Common',          'Queue',           'Housekeeping',           'Sys$Library:Starlet')] Module Mailbox;   K { Mailbox deals with the SYS$ANNOUNCE definition and mailbox which tells us &   when users first start to connect. }   Var MbxChan : [Volatile] Word;   [Asynchronous] Procedure Login_Read_Request;   ' Type Load_Times = (One, Five, Fifteen);   ) Var Loads : Array [One..Fifteen] of Real; (     OutString, AnnounceMsg : LongString;     AnnounceFile : Text;4     CurDate, CurTime : Packed Array [1..11] of Char;     ShutdownTime : GenString; 2     GetShutdownTime, GetAnnounceMsg : ItemList(1);     IOSB : StatusBlock; &     NeedExtraCR : Boolean Value False;       Users_PID : Unsigned; -     Users_Terminal, Users_Access : GenString;      Job_Info : ItemList(2);        Terminal_Chan : Word;   5   Function Send_To_Job(Data : LongString) : Unsigned;      Var Send_IOSB : StatusBlock;     Begin !      Check($QIOW(Chan := MbxChan, '                  Func := IO$_WriteVBlk, #                  IOSB := Send_IOSB, !                  P1 := Data.Body, %                  P2 := Data.Length));       Check(Send_IOSB.Ret_Stat); "      Send_To_Job := Send_IOSB.Misc   End;   Begin 9    { There was a read request made, so let's handle it. } K    Readln(LoadAverageDevice, Loads[One]::RealChars, Loads[Five]::RealChars, %           Loads[Fifteen]::RealChars);        Date(CurDate); Time(CurTime);  "    Set_ItemList(GetAnnounceMsg, 1,1                 BufLen := Size(AnnounceMsg.Body), &                 ItmCod := LNM$_STRING,5                 BufAdr := IAddress(AnnounceMsg.Body), ;                 RetLenAdr := IAddress(AnnounceMsg.Length));   )    If Odd($TRNLNM(TabNam := 'LNM$SYSTEM', +                   LogNam := 'SYS$ANNOUNCE', (                   AcMode := PSL$C_SUPER,1                   ItmLst := GetAnnounceMsg)) Then        Begin J          If (Length(AnnounceMsg) > 1) And_Then (AnnounceMsg[1] = '@') Then             Begin N                Open(AnnounceFile, Substr(AnnounceMsg,2,Length(AnnounceMsg)-1),1                     ReadOnly, Error := Continue); /                If Status(AnnounceFile) = 0 Then                    Begin )                      Reset(AnnounceFile); 3                      While Not Eof(AnnounceFile) Do                          Begin =                            Readln(AnnounceFile, AnnounceMsg); 7                            $FAOL(CtrStr := AnnounceMsg, <                                  OutLen := OutString.Length,:                                  OutBuf := OutString.Body,.                                  PrmLst := 0);>                            Users_PID := Send_To_Job(OutString)                         End;)                      Close(AnnounceFile);                    End              End 
          Else              Begin +                $FAOL(CtrStr := AnnounceMsg, 0                      OutLen := OutString.Length,.                      OutBuf := OutString.Body,"                      PrmLst := 0);2                Users_PID := Send_To_Job(OutString)             End 
       End;      WriteV(OutString,F       '   Load averages: ', Loads[One]:5:2, ' ', Loads[Five]:5:2, ' ',+       Loads[Fifteen]:5:2, ' ':12, 'Jobs: ', <       (SYS$GW_IJOBCNT - NumInQueue - 1):0, ' Interactive, ',*       SYS$GW_BJOBCNT:0, ' Batch'(13, 10));    Send_To_Job(OutString);      Set_ItemList(Job_Info, 1,4                 BufLen := Size(Users_Terminal.Body),,                 ItmCod := JPI$_TT_PHYDEVNAM,8                 BufAdr := IAddress(Users_Terminal.Body),>                 RetLenAdr := IAddress(Users_Terminal.Length));    Set_ItemList(Job_Info, 2,2                 Buflen := Size(Users_Access.Body),,                 ItmCod := JPI$_TT_ACCPORNAM,6                 BufAdr := IAddress(Users_Access.Body),<                 RetLenAdr := IAddress(Users_Access.Length));  '    If Odd($GETJPIW(PidAdr := Users_PID, ,                    ItmLst := Job_Info)) Then       Begin 6          OutString := '   Login on ' + Users_Terminal;#          If Users_Access <> '' Then D             OutString := OutString + ' (from ' + Users_Access + ')';-          OutString := OutString + ''(13, 10);           Send_To_Job(OutString) 
       End;  #    Set_ItemList(GetShutDownTime, 1, 2                 BufLen := Size(ShutDownTime.Body),&                 ItmCod := LNM$_STRING,6                 BufAdr := IAddress(ShutDownTime.Body),<                 RetLenAdr := IAddress(ShutDownTime.Length));)    If Odd($TRNLNM(TabNam := 'LNM$SYSTEM', ,                   LogNam := 'SHUTDOWN$TIME',2                   ItmLst := GetShutDownTime)) Then       Begin F          Send_To_Job('System shutdown scheduled for ' + ShutDownTime);          NeedExtraCR := True
       End;      If SYS$GW_IJOBLIM = 0 Then        Begin           Send_To_Job(''(7, 7) + I                      '        [WARNING: Logins are currently disabled]');           NeedExtraCR := True
       End;  '    If NeedExtraCR Then Send_To_Job('');       Check($QIOW(Chan := MbxChan, #                Func := IO$_WritEof,                 IOSB := IOSB));    Check(IOSB.Ret_Stat);  3    If ((SYS$GW_IJOBCNT - NumInQueue) > MaxUsers) Or +       (Loads[Five] > MaxLoad) Or Debug Then        Begin &          $SUSPND(Pidadr := Users_PID);*          $ASSIGN(DevNam := Users_Terminal,(                  Chan := Terminal_Chan);  D          Insert_Into_Queue(Users_PID, Users_Terminal, Terminal_Chan)
       End;      Check($QIOW(Chan := MbxChan, 3                Func := IO$_SetMode + IO$M_ReadAttn,                 IOSB := IOSB,9                P1 := %Immed IAddress(Login_Read_Request),                 P2 := 0));     Check(IOSB.Ret_Stat)  End;   Procedure Setup_Mailbox;   Var GetDevName : ItemList(1);      CreLnmList : ItemList(1);      DeviceName : GenString;      IOSB : StatusBlock;    Begin 3    { Protection FF00 means (S:RW_P, O:RW_P, G, W) }     Check($CREMBX(PrmFlg := 0, !                  Chan := MbxChan,                   MaxMsg := 256,                    BufQuo := 1024,%                  ProMsk := 16#FF00));   ;    { As soon as it's created, let's set up the AST for it }     Check($QIOW(Chan := MbxChan, 3                Func := IO$_SETMODE + IO$M_READATTN,                 IOSB := IOSB,9                P1 := %Immed IAddress(Login_Read_Request),                 P2 := 0));     Check(IOSB.Ret_Stat);      Set_ItemList(GetDevName, 1,0                 BufLen := Size(DeviceName.Body),*                 ItmCod := DVI$_FULLDEVNAM,4                 BufAdr := IAddress(DeviceName.Body),:                 RetLenAdr := IAddress(DeviceName.Length));  "    Check($GETDVIW(Chan := MbxChan,'                   ItmLst := GetDevName, !                   IOSB := IOSB));     Check(IOSB.Ret_Stat);  "    DeviceName := '@' + DeviceName;    Set_ItemList(CreLnmList, 1,,                 BufLen := DeviceName.Length,&                 ItmCod := LNM$_STRING,5                 BufAdr := IAddress(DeviceName.Body));   (    Check($CRELNM(TabNam := 'LNM$SYSTEM',(                  LogNam := Logical_Name,&                  AcMode := PSL$C_USER,(                  ItmLst := CreLnmList)); End;   End.