N (*****************************************************************************N  *                               Q L O G I N                                 *N  *                              -------------                                *N  *                                                                           *N  *  This module is part of the QLogin package developed by Marc A. Shannon   *N  *  of the Computer Club at Carnegie-Mellon University.                      *N  *                                                                           *N  *  This program, either complete or in part, may not be redistributed for   *N  *  profit.  This program, and all modules, are:                             *N  *      Copyright (C) 1991 by Marc A. Shannon and the CMU Computer Club      *N  *                                                                           *N  *  Redistribution of this package is not otherwise restricted.              *N  *                                                                           *O  *****************************************************************************)  [Ident('V1.0'),   Environment('Interact'),   Inherit('Common',          'QueueDef',          'Attach',          'Priv_Bypass',            'Sys$Library:Starlet')] Module Interact;  F { Interact primarily provides the Receive_From_User procedure which isN   responsible for getting input from the users who are waiting in the queue. }   [Asynchronous]@ Procedure Receive_From_User(Var CurEntry : QueueEntry); Forward;   [Asynchronous]7 Procedure Start_Interaction(Var CurEntry : QueueEntry);    Begin I    { Very simple operation - simply issue the initial $QIO to await input       from the user. }   '    $QIO(Chan := CurEntry.Terminal_Chan, :         Func := IO$_TtyReadAll + IO$M_Purge + IO$M_NoEcho,#         IOSB := CurEntry.Read_Stat, 5         AstAdr := %Immed IAddress(Receive_From_User), ,         AstPrm := %Immed IAddress(CurEntry),!         P1 := CurEntry.Char_Buff,          P2 := 1);        CurEntry.State := Waiting  End;   [Asynchronous]7 Procedure Send_Queue_Status(Var CurEntry : QueueEntry);    Var StatLine : LongString;+     CurTime : Packed Array [1..11] of Char;    Begin     Time(CurTime); N    WriteV(StatLine, CurTime:8, ' - QLogin #', CurEntry.EntryNum:0, ' out of ',;           NumInQueue:0, ' - Load: ', CurrentLoad:5:2, ' (',            MaxLoad:5:2, ') - ',F           'Interactive jobs: ', (SYS$GW_IJobCnt - NumInQueue):0, ' (',           MaxUsers:3, ')'); /    Write_Out(DevChan := CurEntry.Terminal_Chan,               Data := StatLine);       Start_Interaction(CurEntry);       CurEntry.State := Waiting End;   [Asynchronous]8 Procedure Dump_Queue(Var CurEntry : QueueEntry); Extern;   { from forward } Procedure Receive_From_User;   Label Abort;   Var Search : Integer;    Begin 3    If CurEntry.Read_Stat.Ret_Stat <> SS$_ABORT Then 5       If Not Odd(CurEntry.Read_Stat.Ret_Stat) Or_Else =          (CurEntry.Char_Buff In [''(3), ''(25), ''(26)]) Then           Begin4             If Odd(CurEntry.Read_Stat.Ret_Stat) Then;                Write_Out(DevChan := CurEntry.Terminal_Chan, D                          Data := 'Leaving queue per your request.');,             $DELPRC(PidAdr := CurEntry.PID);+             CurEntry.State := ToBeReleased;              WakeUp          End
       Else          Begin&             Case CurEntry.Char_Buff Of                '?' : BeginE                         Write_File(DevChan := CurEntry.Terminal_Chan, >                                    DataFile := 'QLOGIN_HELP');3                         Start_Interaction(CurEntry)                       End; *                ''(1) : Reattach(CurEntry);$                ''(18),''(20) : BeginG                                   { Do it this way to load the new load B                                     averages into HouseKeeping forJ                                     consistency.  Start_IO causes a notify9                                     to be sent as well. } ;                                   CurEntry.State := Notify; (                                   WakeUp#                                End;                 ''(16) : Begin 0                            Dump_Queue(CurEntry);6                            Start_Interaction(CurEntry)                         End;1                ''(5) : PrivilegedBypass(CurEntry) 4                Otherwise Start_Interaction(CurEntry)             End 
          End;    Abort: End;   End.