N (*****************************************************************************N  *                               Q L O G I N                                 *N  *                              -------------                                *N  *                                                                           *N  *  This module is part of the QLogin package developed by Marc A. Shannon   *N  *  of the Computer Club at Carnegie-Mellon University.                      *N  *                                                                           *N  *  This program, either complete or in part, may not be redistributed for   *N  *  profit.  This program, and all modules, are:                             *N  *      Copyright (C) 1991 by Marc A. Shannon and the CMU Computer Club      *N  *                                                                           *N  *  Redistribution of this package is not otherwise restricted.              *N  *                                                                           *O  *****************************************************************************)  [Ident('V1.0'),   Environment('Common'), +  Inherit('Sys$Library:Pascal$LIB_Routines',            'Sys$Library:Starlet')] Module Common(Output);  M { This module provides the commonly used routines and definitions (mostly for     I/O) for the QLogin program. }  $ Const Logical_Name = 'SYS$ANNOUNCE';+       Process_Name_Const = 'Sys$Announcer';        Process_UIC = %X00010004; .       Housekeeping_Cycle = '0000 00:00:15.00';       Max_Attach_PIDs = 32;   "       { From the $STATEDEF macro }       SCH$C_SUSP  =  9;        SCH$C_SUSPO = 10;    Type Byte = [Byte] 0..255;      Word = [Word] 0..65535;&      GenString = Varying [32] of Char;(      LongString = Varying [254] of Char;  .      ItemList(N : Integer) = Array [1..N+1] Of&                                 Record1                                    BufLen : Word; 1                                    ItmCod : Word; 5                                    BufAdr : Unsigned; 7                                    RetLenAdr : Unsigned /                                 End Value Zero;       StatusBlock = Record &                       Ret_Stat : Word;#                       Bytes : Word; %                       Misc : Unsigned                     End;       Quad = [Quad] Record $                       L0 : Unsigned;"                       L1 : Integer                    End;       QuadPtr = ^Quad; 3      Fixed8 = Packed Array [1..Size(Quad)] of Char; 6      RealChars = Packed Array [1..Size(Real)] Of Char;   Var  SYS$GW_IJOBCNT,      SYS$GW_BJOBCNT,0      SYS$GW_IJOBLIM : [External, ReadOnly] Word;-      NumInQueue : [Volatile] Integer Value 0; ,      CurrentLoad, MaxLoad : [Volatile] Real;#      MaxUsers : [Volatile] Integer; 4      Debug : [Volatile, Static] Boolean Value False;2      WakeEF, ClockEF : [Volatile, Static] Integer;*      EFMask : [Volatile, Static] Unsigned;  9      { Variables used solely by the TO BEGIN DO routine }       Ret_Stat : Integer;$      Startup_ItemList : ItemList(2);-      Startup_Context, Startup_PID : Unsigned;       Process_Gone : Boolean;+      CurProcName, Process_Name : GenString;       CurImageName : LongString;       Startup_Privs : Quad;,      Startup_Quotas : Array [1..7] of Record5                                          Item : Byte; 6                                          Val : Integer*                                       End;   [Asynchronous]: Function Change_UIC(NewUIC : Unsigned) : Unsigned; Extern;   [Asynchronous]* Procedure Check(InErr : [Unsafe] Integer);   Begin .    If Not Odd(InErr) Then $EXIT(Code := InErr) End;   [Asynchronous]4 Procedure Set_ItemList(Var ItemListEntry : ItemList;1                            ItemListNum : Integer; )                            BufLen : Word; )                            ItmCod : Word; -                            BufAdr : Unsigned; 6                            RetLenAdr : Unsigned := 0);   Begin /    ItemListEntry[ItemListNum].BufLen := BufLen; /    ItemListEntry[ItemListNum].ItmCod := ItmCod; /    ItemListEntry[ItemListNum].BufAdr := BufAdr; 4    ItemListEntry[ItemListNum].RetLenAdr := RetLenAdr End;   [Asynchronous]# Procedure Write_Out(DevChan : Word; #                     Data : String);    Begin     $QIOW(Chan := DevChan,           Func := IO$_WRITEVBLK,           P1 := Data.Body,           P2 := Data.Length, >          P4 := 1)  { 1 causes normal VMS CC (^J - text - ^M) } End;   [Asynchronous]$ Procedure Write_File(DevChan : Word;+                      DataFile : GenString);    Var FileBuff : Text;%     DataLine : Varying [254] of Char;    Begin 9    Open(FileBuff, DataFile, ReadOnly, Error := Continue);     If Status(FileBuff) = 0 Then        Begin ,          Reset(FileBuff, Error := Continue);%          If Status(FileBuff) = 0 Then &             While Not Eof(FileBuff) Do                Begin-                   Readln(FileBuff, DataLine); .                   Write_Out(DevChan, DataLine)                End; +          Close(FileBuff, Error := Continue) 	       End  End;   [Initialize] Procedure Get_WakeEF;    Begin 5    LIB$GET_EF(Event_Flag_Number := WakeEF::Unsigned); $    If WakeEF = -1 Then WakeEF := 63;6    LIB$GET_EF(Event_Flag_Number := ClockEF::Unsigned);&    If ClockEF = -1 Then ClockEF := 62;  B    { Make sure that the two event flags are in the same cluster! }0    If UAnd(WakeEF, 32) <> UAnd(ClockEF, 32) Then        $EXIT(Code := SS$_ILLEFC);  C    EFMask := Uor(2 ** (UAnd(WakeEF, 31)), 2 ** (UAnd(ClockEF, 31)))  End;   [Asynchronous] Procedure WakeUp;    Begin     $SETEF(Efn := WakeEF) End;   [Asynchronous]& Procedure Resume_Proc(PID : Unsigned);   Var JPI_ItemList : ItemList(1);      ProcState : Integer;   Begin      Set_ItemList(JPI_ItemList, 1,*                 BufLen := Size(ProcState),%                 ItmCod := JPI$_STATE, /                 BufAdr := IAddress(ProcState)); !    If Odd($GETJPIW(PidAdr := PID, 0                    ItmLst := JPI_ItemList)) ThenC       If (ProcState = SCH$C_SUSP) Or (ProcState = SCH$C_SUSPO) Then           $RESUME(PidAdr := PID)  End;  I { This should be called before any other routine in the program.  Here we I   will check to see if we are detached and, if not, create ourselves as a    detached process. }    To Begin Do     Begin)       Process_Name := Process_Name_Const;   '       Set_ItemList(Startup_ItemList, 1, 4                    BufLen := Size(CurProcName.Body),)                    ItmCod := JPI$_PRCNAM, 8                    BufAdr := IAddress(CurProcName.Body),>                    RetLenAdr := IAddress(CurProcName.Length));'       Set_ItemList(Startup_ItemList, 2, 5                    BufLen := Size(CurImageName.Body), +                    ItmCod := JPI$_IMAGNAME, 9                    BufAdr := IAddress(CurImageName.Body), ?                    RetLenAdr := IAddress(CurImageName.Length)); +       $GETJPIW(ItmLst := Startup_ItemList);   )       If CurProcName <> Process_Name Then           Begin             Repeat$                Process_Gone := True;  0                Set_ItemList(Startup_ItemList, 1,;                             BufLen := Length(Process_Name), 4                             ItmCod := PSCAN$_PRCNAM,B                             BufAdr := IAddress(Process_Name.Body),6                             RetLenAdr := PSCAN$M_EQL);0                Set_ItemList(Startup_ItemList, 2,(                             BufLen := 0,5                             ItmCod := PSCAN$_JOBTYPE, 5                             BufAdr := JPI$K_DETACHED, 6                             RetLenAdr := PSCAN$M_EQL);0                Set_ItemList(Startup_ItemList, 3,(                             BufLen := 0,1                             ItmCod := PSCAN$_UIC, 2                             BufAdr := Process_UIC,6                             RetLenAdr := PSCAN$M_EQL);  $                Startup_Context := 0;  7                $PROCESS_SCAN(PidCtx := Startup_Context, 9                              ItmLst := Startup_ItemList);   0                Set_ItemList(Startup_ItemList, 1,8                             BufLen := Size(Startup_PID),/                             ItmCod := JPI$_PID, =                             BufAdr := IAddress(Startup_PID)); +                Startup_ItemList[2] := Zero;   9                If Odd($GETJPIW(PidAdr := Startup_Context, @                                ItmLst := Startup_ItemList)) Then                   Begin 3                      $FORCEX(PidAdr := Startup_PID, 0                              Code := SS$_ABORT);.                      LIB$WAIT(Seconds := 2.0);*                      Process_Gone := False                   End              Until Process_Gone;   -             { Now we can create the process } N             Startup_Privs.L0 := PRV$M_CMKRNL +    { to change UIC for ATTACH }N                                 PRV$M_OPER +      { to use $BRKTHRU for ^E's }O                                 PRV$M_SHARE +     { to assign chan to new job } L                                 PRV$M_SYSNAM +    { to define SYS$ANNOUNCE }M                                 PRV$M_SYSPRV +    { to access the terminals } N                                 PRV$M_TMPMBX +    { to create the system mbx }O                                 PRV$M_WORLD;      { to check for ATTACH procs }   L             Startup_Quotas[1].Item := PQL$_ASTLM; { about 1 per queued job })             Startup_Quotas[1].Val  := 60; L             Startup_Quotas[2].Item := PQL$_BIOLM; { about 1 per queued job })             Startup_Quotas[2].Val  := 60; M             Startup_Quotas[3].Item := PQL$_BYTLM; { enough for mailbox (1K) } +             Startup_Quotas[3].Val  := 2048; K             Startup_Quotas[4].Item := PQL$_TQELM; { >1 (for HouseKeeping) } )             Startup_Quotas[4].Val  := 10; K             Startup_Quotas[5].Item := PQL$_WSQUOTA;  { use judgement here } *             Startup_Quotas[5].Val  := 400;K             Startup_Quotas[6].Item := PQL$_WSEXTENT; { use judgement here } *             Startup_Quotas[6].Val  := 850;3             Startup_Quotas[7].Item := PQL$_LISTEND;   6             Ret_Stat := $CREPRC(PidAdr := Startup_PID,6                                 Image := CurImageName,8                                 Error := 'QLOGIN_ERROR',8                                 PrvAdr := Startup_Privs,8                                 Quota := Startup_Quotas,7                                 PrcNam := Process_Name, ,                                 BasPri := 6,3                                 UIC := Process_UIC, G                                 StsFlg := PRC$M_PSWAPM + PRC$M_DETACH); !             If Odd(Ret_Stat) Then M                Writeln('QLogin process started -- ID ', Hex(Startup_PID, 8));   #             $EXIT(Code := Ret_Stat)           End    End;    End.